/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_SHORTCUT_EDITOR_H_
#define _LAUNCHER_SHORTCUT_EDITOR_H_

#include <glib-object.h>
#include <gtk/gtk.h>

#include "launcher-menu.h"


#define LAUNCHER_TYPE_SHORTCUT_EDITOR (launcher_shortcut_editor_get_type ())

#define LAUNCHER_SHORTCUT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_SHORTCUT_EDITOR, LauncherShortcutEditor))

#define LAUNCHER_SHORTCUT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_SHORTCUT_EDITOR, LauncherShortcutEditorClass))

#define LAUNCHER_IS_SHORTCUT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_SHORTCUT_EDITOR))

#define LAUNCHER_IS_SHORTCUT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_SHORTCUT_EDITOR))

#define LAUNCHER_SHORTCUT_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_SHORTCUT_EDITOR, LauncherShortcutEditorClass))

typedef struct _LauncherShortcutEditor        LauncherShortcutEditor;
typedef struct _LauncherShortcutEditorClass   LauncherShortcutEditorClass;
typedef struct _LauncherShortcutEditorPrivate LauncherShortcutEditorPrivate;
 
struct _LauncherShortcutEditor
{
  GtkDialog        parent;	

  LauncherShortcutEditorPrivate *priv;
};

struct _LauncherShortcutEditorClass
{
  GtkDialogClass   parent_class;
};

enum
{
  SHORTCUT_TYPE_WEB=0,
  SHORTCUT_TYPE_FILE,
  SHORTCUT_TYPE_FOLDER,
  SHORTCUT_TYPE_APP
};


GType       launcher_shortcut_editor_get_type (void) G_GNUC_CONST;

GtkWidget * launcher_shortcut_editor_new      ();


#endif /* _LAUNCHER_SHORTCUT_EDITOR_H_ */

