/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef QT_GCONFITEM_QML_WRAPPER_H
#define QT_GCONFITEM_QML_WRAPPER_H

#include <QObject>
#include <QVariant>

class GConfItem;

class GConfItemQmlWrapper : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString key READ getKey WRITE setKey);
    Q_PROPERTY(QVariant value READ getValue WRITE setValue NOTIFY valueChanged);
    Q_PROPERTY(QVariant entries READ getEntries NOTIFY subtreeChanged);
    Q_PROPERTY(QVariant dirs READ getDirs NOTIFY subtreeChanged);

public:
    GConfItemQmlWrapper(QObject *parent = 0);
    ~GConfItemQmlWrapper();

    // getters
    const QString getKey() const;
    const QVariant getValue() const;
    const QVariant getEntries() const;
    const QVariant getDirs() const;

    // setters
    void setKey(const QString &key);
    void setValue(const QVariant &value);

signals:
    void valueChanged() const;
    void subtreeChanged() const;

private:
    GConfItem *m_item;
};

#endif // QT_GCONFITEM_QML_WRAPPER_H

