#ifndef _LOG_H_
#define _LOG_H_

#ifdef OS_ANDROID
#include <utils/Log.h>
#else
#include <stdio.h>
#include "config.h"
#ifndef __cplusplus
#define true (1)
#define false (0)
#endif
#define ALOG(format, ...) printf(format "\n", __VA_ARGS__)
#define ALOGV(...) ALOG(__VA_ARGS__)
#define ALOGD(...) ALOG(__VA_ARGS__)
#define ALOGI(...) ALOG(__VA_ARGS__)
#define ALOGW(...) ALOG(__VA_ARGS__)
#define ALOGE(...) ALOG(__VA_ARGS__)
#define ALOG_IF(cond, ...) ( (cond) ? ((void)ALOG(__VA_ARGS__)) : (void)0 )
#define ALOGV_IF(...) ALOG_IF(__VA_ARGS__)
#define ALOGD_IF(...) ALOG_IF(__VA_ARGS__)
#define ALOGI_IF(...) ALOG_IF(__VA_ARGS__)
#define ALOGW_IF(...) ALOG_IF(__VA_ARGS__)
#define ALOGE_IF(...) ALOG_IF(__VA_ARGS__)
#endif // OS_ANDROID

#endif // _LOG_H_
