/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _MESSAGE_H_
#define _MESSAGE_H_

#include "libsensorhub.h"

#define REQUIRE_NONE                   (0)
#define REQUIRE_CREATE_SESSION_DATA_FD (1)
#define REQUIRE_CREATE_SESSION_CTRL_FD (2)
#define REQUIRE_START_STREAMING        (3)
#define REQUIRE_STOP_STREAMING         (4)
#define REQUIRE_FLUSH_STREAMING        (5)
#define REQUIRE_SET_PROPERTY           (6)
#define REQUIRE_GET_PROPERTY           (7)
#define REQUIRE_GET_SENSORS_LIST        (8)

// The max send buffer size is more than 128K for Unix domain socket.
typedef struct {
        uint8_t require_code;
        uint8_t ack; // acknowledge bit, if set to 1, means this message is a acknowledge message.
        uint16_t acknowledge_number; // if it is a acknowledge message, it should set to the size of the data received.
        uint16_t data_size;
        uint8_t data[0];
} __attribute__ ((packed)) sensorhub_message_header_t;

typedef struct {
        int handle;
        int64_t sampling_period_us;
        int64_t max_report_latency_us;
} __attribute__ ((packed)) start_streaming_data_t;

typedef struct {
        sensorhub_message_header_t header;
} __attribute__ ((packed)) msg_create_session_data_fd;

typedef struct {
        sensorhub_message_header_t header;
        session_id_t session;
        session_category_t category;
} __attribute__ ((packed)) msg_create_session_ctrl_fd;

typedef struct {
        sensorhub_message_header_t header;
        start_streaming_data_t data;
} __attribute__ ((packed)) msg_start_streaming;

typedef struct {
        sensorhub_message_header_t header;
        int handle;
} __attribute__ ((packed)) msg_simple_command;

typedef msg_simple_command msg_stop_streaming;

typedef msg_simple_command msg_flush_streaming;

typedef struct {
        sensorhub_message_header_t header;
        sensor_list_flag_t flag;
} __attribute__ ((packed)) msg_get_sensors_list;

typedef struct {
        sensorhub_message_header_t header;
        uint8_t result;
} __attribute__ ((packed)) msg_simple_resp;

typedef struct {
        sensorhub_message_header_t header;
        session_id_t session;
} __attribute__ ((packed)) msg_create_session_data_fd_resp;

#endif
