/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.io.DataIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;

public class TreeNodeID
implements DataIO {
    public static final int BYTESIZE = 6;
    public static final Order INCRE_INDEX_ORDER = new IncreasingIndexOrder();
    public static final Order DECRE_INDEX_ORDER = new DecreasingIndexOrder();
    public short depth;
    public int xpos;

    public TreeNodeID(short s, int n) {
        this.depth = s;
        this.xpos = n;
    }

    public TreeNodeID(TreeNodeID treeNodeID) {
        this.depth = treeNodeID.depth;
        this.xpos = treeNodeID.xpos;
    }

    public TreeNodeID getParentNodeID(int n) {
        return new TreeNodeID((short)(this.depth + 1), this.xpos / n);
    }

    public void toParent(int n) {
        this.depth = (short)(this.depth + 1);
        this.xpos /= n;
    }

    public void toNextSibling() {
        ++this.xpos;
    }

    public void toPreviousSibling() {
        --this.xpos;
    }

    public boolean isPossibleRoot() {
        return this.xpos == 0;
    }

    public boolean isLeaf() {
        return this.depth == 0;
    }

    public boolean equals(TreeNodeID treeNodeID) {
        return this.depth == treeNodeID.depth && this.xpos == treeNodeID.xpos;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.depth);
        dataOutput.writeInt(this.xpos);
    }

    public TreeNodeID(DataInput dataInput) throws IOException {
        this.readObject(dataInput);
    }

    public void readObject(DataInput dataInput) throws IOException {
        this.depth = dataInput.readShort();
        this.xpos = dataInput.readInt();
    }

    public String toString() {
        return "ID(" + this.depth + "," + this.xpos + ")";
    }

    public static final void main(String[] stringArray) {
        TreeNodeID treeNodeID;
        int n;
        int n2;
        short s;
        int n3;
        TreeMap<TreeNodeID, String> treeMap = new TreeMap<TreeNodeID, String>();
        for (n3 = 4; n3 >= 0; n3 = (int)((short)(n3 - 1))) {
            s = (short)(4 - n3);
            n2 = (int)Math.pow(2.0, n3);
            for (n = n2 - 1; n >= 0; --n) {
                treeMap.put(new TreeNodeID(s, n), new String("_" + n3 + ", " + n + "_"));
            }
        }
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            treeNodeID = (TreeNodeID)iterator.next().getKey();
            if (treeNodeID.isPossibleRoot()) {
                System.out.println("\n" + treeNodeID);
                continue;
            }
            System.out.println(treeNodeID);
        }
        System.out.println("\n\n");
        TreeSet<TreeNodeID> treeSet = new TreeSet<TreeNodeID>(INCRE_INDEX_ORDER);
        for (n3 = 0; n3 <= 4; n3 = (int)((short)(n3 + 1))) {
            s = (short)(4 - n3);
            n2 = (int)Math.pow(2.0, n3);
            for (n = n2 - 1; n >= 0; --n) {
                treeSet.add(new TreeNodeID(s, n));
            }
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            treeNodeID = (TreeNodeID)((Object)iterator.next());
            if (treeNodeID.isPossibleRoot()) {
                System.out.println("\n" + treeNodeID);
                continue;
            }
            System.out.println(treeNodeID);
        }
        System.out.println("\n\n");
        treeSet = new TreeSet(DECRE_INDEX_ORDER);
        for (n3 = 0; n3 <= 4; n3 = (int)((short)(n3 + 1))) {
            s = (short)(4 - n3);
            n2 = (int)Math.pow(2.0, n3);
            for (n = n2 - 1; n >= 0; --n) {
                treeSet.add(new TreeNodeID(s, n));
            }
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            treeNodeID = (TreeNodeID)((Object)iterator.next());
            if (treeNodeID.isPossibleRoot()) {
                System.out.println(treeNodeID + "\n");
                continue;
            }
            System.out.println(treeNodeID);
        }
    }

    private static class DecreasingIndexOrder
    implements Order {
        private DecreasingIndexOrder() {
        }

        public int compare(Object object, Object object2) {
            TreeNodeID treeNodeID = (TreeNodeID)object;
            TreeNodeID treeNodeID2 = (TreeNodeID)object2;
            if (treeNodeID.depth == treeNodeID2.depth) {
                if (treeNodeID.xpos == treeNodeID2.xpos) {
                    return 0;
                }
                return treeNodeID.xpos > treeNodeID2.xpos ? -1 : 1;
            }
            return treeNodeID.depth > treeNodeID2.depth ? -1 : 1;
        }

        public boolean isIncreasingIndexOrdered() {
            return false;
        }
    }

    private static class IncreasingIndexOrder
    implements Order {
        private IncreasingIndexOrder() {
        }

        public int compare(Object object, Object object2) {
            TreeNodeID treeNodeID = (TreeNodeID)object;
            TreeNodeID treeNodeID2 = (TreeNodeID)object2;
            if (treeNodeID.depth == treeNodeID2.depth) {
                if (treeNodeID.xpos == treeNodeID2.xpos) {
                    return 0;
                }
                return treeNodeID.xpos < treeNodeID2.xpos ? -1 : 1;
            }
            return treeNodeID.depth > treeNodeID2.depth ? -1 : 1;
        }

        public boolean isIncreasingIndexOrdered() {
            return true;
        }
    }

    public static interface Order
    extends Comparator {
        public boolean isIncreasingIndexOrdered();
    }
}

