/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: baseprocessor2d.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: aw $ $Date: 2008-06-24 15:31:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_drawinglayer.hxx"

#include <drawinglayer/processor2d/baseprocessor2d.hxx>

//////////////////////////////////////////////////////////////////////////////

using namespace com::sun::star;

//////////////////////////////////////////////////////////////////////////////

namespace drawinglayer
{
	namespace processor2d
	{
		void BaseProcessor2D::processBasePrimitive2D(const primitive2d::BasePrimitive2D& /*rCandidate*/)
		{
		}

		BaseProcessor2D::BaseProcessor2D(const geometry::ViewInformation2D& rViewInformation)
		:	maViewInformation2D(rViewInformation)
		{
		}

		BaseProcessor2D::~BaseProcessor2D()
		{
		}

		void BaseProcessor2D::process(const primitive2d::Primitive2DSequence& rSource)
		{
			if(rSource.hasElements())
			{
				const sal_Int32 nCount(rSource.getLength());

				for(sal_Int32 a(0L); a < nCount; a++)
				{
					// get reference
					const primitive2d::Primitive2DReference xReference(rSource[a]);

					if(xReference.is())
					{
						// try to cast to BasePrimitive2D implementation
						const primitive2d::BasePrimitive2D* pBasePrimitive = dynamic_cast< const primitive2d::BasePrimitive2D* >(xReference.get());

						if(pBasePrimitive)
						{
							// it is a BasePrimitive2D implementation, use local processor
							processBasePrimitive2D(*pBasePrimitive);
						}
						else
						{
							// unknown implementation, use UNO API call instead and process recursively
							const uno::Sequence< beans::PropertyValue >& rViewParameters(getViewInformation2D().getViewInformationSequence());
							process(xReference->getDecomposition(rViewParameters));
						}
					}
				}
			}
		}
	} // end of namespace processor2d
} // end of namespace drawinglayer

//////////////////////////////////////////////////////////////////////////////
// eof
