#include "video.h"
extern char **video[3];
extern int dialogTimerId;
extern int timeCount;

gboolean videoConnect=FALSE;
gboolean videoKey=FALSE;
int videoValue=0;
int videoCount=0;
int lcdResolution=0;
int vgaResolution=0;
void checkVideoConnect(){
    Display *display=XOpenDisplay(NULL);
    int screen=DefaultScreen(display);
    Window rootWindow=RootWindow(display,screen);
    XRRScreenResources *res=XRRGetScreenResources (display, rootWindow);
    XRROutputInfo *output_info = XRRGetOutputInfo (display, res, res->outputs[0]);
    if (output_info->connection==0)videoConnect=TRUE;
    else videoConnect=FALSE;
    XCloseDisplay(display);
    delete res;
    delete output_info;
}

void setVideoValue(){
    if(videoCount==0){
        checkVideoConnect();
    }
    if(videoConnect){
            videoKey=TRUE;
            timeCount=0;
            int v=(videoValue+videoCount++)%3;
            setImage(video[v]);
            if(videoCount>1){
                gtk_timeout_remove(dialogTimerId);
            }
    }
}
void setVideo(){
        gtk_widget_hide(dialog);
        GdkDisplay *display = gdk_display_get_default ();
        XFlush (GDK_DISPLAY_XDISPLAY (display));
        gdk_flush();
        usleep(1000000);//切換前會有空白殘影，延遲一秒讓gtk有足夠時間清除空白殘影
        videoKey=FALSE;
        if(videoConnect){
                videoValue=(videoValue+videoCount-1)%3;
                videoCount=0;
                switch(videoValue){
                        case 0:
                            if (lcdResolution==0) {
				system("xrandr --output LVDS --mode 1024x600 --auto");
                            } else 
				system("xrandr --output LVDS --mode 800x600 --auto");
                            system("xrandr --output VGA --off");
                            break;
                        case 1:
                            system("xrandr --output LVDS --mode 800x600 --auto");
                            system("xrandr --output VGA --mode 800x600 --auto");
                            break;
                        case 2:
                            if (vgaResolution==0) {
				system("xrandr --output VGA --mode 1024x768 --auto");
                            } else 
				system("xrandr --output VGA --mode 800x600 --auto");
                            system("xrandr --output LVDS --off");
                            break;
                }
        }
}
